//------------------------------------
//  FolderWatcher.cpp
//  (c) Reliable Software, 1997
//------------------------------------

#include "FolderWatcher.h"

void DisplayIOError (char const *operation, char const *fileName)
{
    char const format[] = "%s\nFile: '%s'\nSystem reports: %s";
    char *buf;
    char *sysMsg;
    int err = GetLastError ();
 
    FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
                  NULL,
                  err,
                  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
                  (LPTSTR) &sysMsg,
                  0,
                  NULL 
                 );
    buf = new char [strlen (sysMsg) + strlen (operation) + strlen(fileName) + strlen (format) + 1];
    wsprintf (buf, format, operation, fileName, sysMsg);
    MessageBox (0, buf, "File Operation Problem", MB_ICONERROR | MB_OK);

    // Free the buffer.
    LocalFree (sysMsg);
    delete buf;
}

void FolderWatcher::Loop ()
{
    for (;;)
    {
        // Wait for change notification
        DWORD waitStatus = WaitForSingleObject (_notifySource, INFINITE);
        if (WAIT_OBJECT_0 == waitStatus)
        {
            // If folder changed
            if (_isDying)
                return;

            PostMessage (_hwndNotifySink, WM_FOLDER_CHANGE, 0, (LPARAM) _folder);

            // Continue change notification
            if (!_notifySource.ContinueNotification ())
            {
                // Continuation failed
                DisplayIOError ("Cannot detect changes in folder", _folder);
                return;
            }
        }
        else
        {
            // Wait failed
            DisplayIOError ("Cannot detect changes in folder", _folder);
            return;
        }
    }
}