//------------------------------------
//  control.cpp
//  (c) Reliable Software, 1997
//------------------------------------
#include "control.h"
#include "main.h"
#include "resource.h"

// Window Proc

LRESULT CALLBACK WndProc
    (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    static Controller * pCtrl;

    switch (message)
    {
    case WM_CREATE:
        try
        {
            pCtrl = new Controller (hwnd, (CREATESTRUCT *) lParam);
        }
        catch (WinException e)
        {
            e.Display ();
            return -1;
        }
        catch (...)
        {
            MessageBox (hwnd, "Unknown Error", "Initialization", 
                MB_ICONEXCLAMATION | MB_OK);
            return -1;
        }
        return 0;
    case WM_FOLDER_CHANGE:
        pCtrl->OnFolderChange (hwnd, (char const *) lParam);
        return 0;
    case WM_SYSCOMMAND:
        if (pCtrl->SysCommand (hwnd, LOWORD (wParam)))
            return 0;
        break;
    case WM_DESTROY:
        delete pCtrl;
        return 0;
    }
    return DefWindowProc (hwnd, message, wParam, lParam);
}

Controller::Controller (HWND hwnd, CREATESTRUCT * pCreate)
   :
    _folderWatcher (pCreate->lpszName, hwnd),
    _hInst (pCreate->hInstance)
{
}

Controller::~Controller()
{
    PostQuitMessage(0);
}

BOOL Controller::SysCommand (HWND hwnd, int cmd)
{
    switch (cmd)
    {
    case IDM_ABOUT:
        DialogBox (_hInst, "About", hwnd, DLGPROC(AboutDlgProc));
        return TRUE;
    case SC_RESTORE:
        return TRUE;
    }
    return FALSE;
}

void Controller::OnFolderChange (HWND hwnd, char const * folder)
{
    char const format [] = "Folder '%s' has changed";
    char * buf = new char [strlen (format) + strlen (folder) + 1];
    wsprintf (buf, format, folder);
    MessageBox (hwnd, buf, "Folder Watcher", MB_SETFOREGROUND | MB_ICONEXCLAMATION | MB_OK);
    delete buf;
}

// "About" dialog box procedure
// Process messages from dialog box

BOOL CALLBACK AboutDlgProc
   (HWND hwnd, UINT message, UINT wParam, LPARAM lParam)
{
    switch (message)
    {
    case WM_INITDIALOG:
        return TRUE;
    case WM_COMMAND:
        switch (LOWORD(wParam))
        {
        case IDOK:
        case IDCANCEL:
            EndDialog(hwnd, 0);
            return TRUE;
        }
        break;
    }
    return FALSE;
}

