//------------------------------------
//  main.cpp
//  (c) Reliable Software, 1997
//------------------------------------

#include "main.h"
#include <new.h>

int PASCAL WinMain
    (HINSTANCE hInst, HINSTANCE hPrevInst, char * cmdParam, int cmdShow)
{
    if (!strlen (cmdParam))
    {
        MessageBox (0, "Please, specify folder to watch", "Folder Watcher", MB_ICONEXCLAMATION | MB_OK);
        return 0;
    }

    char className [] = "Folder Watcher";
    _set_new_handler (&NewHandler);

    BOOL isError = FALSE;
    try
    {
        WindowClass winClass (WndProc, className, hInst);
        winClass.Register ();

        Window win (cmdParam, className, hInst);
        
        // Add "About ..." to the system menu
        HMENU hSysMenu = GetSystemMenu (win, FALSE);
        AppendMenu (hSysMenu, MF_SEPARATOR, 0, NULL);
        AppendMenu (hSysMenu, MF_STRING, IDM_ABOUT, "About ...");
        // Disable Restore item
        EnableMenuItem (hSysMenu, 0, MF_BYPOSITION | MF_GRAYED);
        win.Show (SW_SHOWMINNOACTIVE);
    }
    catch ( WinException e )
    {
        e.Display ();
        isError = TRUE;
    }
    catch (...)
    {
        MessageBox (0, "Unknown", "Exception", MB_ICONEXCLAMATION | MB_OK);
        isError = TRUE;
    }

    if (isError)
        return 0;

    // The main message loop
    MSG  msg;
    int status;
    while ((status = GetMessage (&msg, 0, 0, 0)) != 0)
    {
        if (status == -1)
            return -1;
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }

    return msg.wParam;
}            

WindowClass::WindowClass (WNDPROC WndProc, char const * className, HINSTANCE hInst)
{
    cbSize = sizeof (WNDCLASSEX);
    style = CS_HREDRAW | CS_VREDRAW;
    lpfnWndProc = WndProc;       // window procedure: mandatory
    cbClsExtra = 0;
    cbWndExtra = 0;
    hInstance = hInst;           // owner of the class: mandatory
    hIcon = LoadIcon (hInst, MAKEINTRESOURCE (IDI_LOGO));
    hIconSm = LoadIcon (hInst, MAKEINTRESOURCE (IDI_LOGO));
    hCursor = LoadCursor (0, IDC_ARROW); // optional
    hbrBackground = (HBRUSH) (COLOR_WINDOW + 1); // optional
    lpszMenuName = className;
    lpszClassName = className;   // mandatory
}

Window::Window (char const * caption, char const * className, HINSTANCE hInstance)
{
    _hwnd = CreateWindow (
        className,
        caption,
        WS_SYSMENU | WS_MINIMIZE,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        NULL,
        NULL,
        hInstance,
        NULL );
    if (_hwnd == 0)
        throw "Window Creation Failed";
}

int NewHandler (size_t size)
{
    throw WinException ( "Out of memory" );
    return 0;
}


