#if !defined WINEX_H
#define WINEX_H
//------------------------------------
//  (c) Reliable Software, 1997
//------------------------------------

#include <windows.h>

char const msgFormat[] = "Our problem: %s\nSystem tells us: %s";
 
class WinException
{
public:
    WinException (char* msg)
    : _err (GetLastError()), _msg(msg)
    {}
    void Display () const
    {
        char *buf;
        char *sysMsg;
 
        FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
                      NULL,
                      _err,
                      MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
                      (LPTSTR) &sysMsg,
                      0,
                      NULL 
                     );
        buf = new char [strlen (sysMsg) + strlen (_msg) + strlen (msgFormat) + 1];
        wsprintf ( buf, msgFormat, _msg, sysMsg );
        MessageBox (0, buf, "Exception", MB_ICONEXCLAMATION | MB_OK);

        // Free the buffer.
        LocalFree (sysMsg);
        delete buf;
    }

    DWORD GetError () const { return _err; }

private:
    DWORD _err;
    char* _msg;
};

#endif

